import JSONSerializer from 'ember-data/serializers/json';
import { underscore } from 'ember-string';

export default JSONSerializer.extend({
  keyForAttribute: underscore,

  normalizeFindRecordResponse(store, primaryModelClass, payload) {
    payload.id = 'user';
    return this._super(...arguments);
  },

  pushPayload(store, payload) {
    let modelClass = store.modelFor('onsite-notification-summary');
    let document = this.normalizeFindRecordResponse(store, modelClass, payload);
    return store.push(document);
  }
});
