import JSONSerializer from 'ember-data/serializers/json';
import { underscore } from 'ember-string';

export default JSONSerializer.extend({
  keyForAttribute: underscore,

  normalizeQueryResponse(store, primaryModelClass, payload, id, requestType) {
    let document = this._super(store, primaryModelClass, payload.notifications, id, requestType);
    document.meta = {
      cursor: payload.cursor
    };
    return document;
  },

  pushPayload(store, payload) {
    let modelClass = store.modelFor('onsite-notification');
    let document = this.normalizeFindRecordResponse(store, modelClass, payload);
    return store.push(document);
  }
});
