import JSONSerializer from 'ember-data/serializers/json';
import injectService from 'ember-service/inject';

export default JSONSerializer.extend({
  isNewSerializerAPI: true,
  session: injectService(),

  _buildJSONAPI(payload) {
    return {
      data: {
        id: this.get('session.userData.id'),
        type: 'presence-settings',
        attributes: payload
      }
    };
  },

  normalizeQueryRecordResponse(store, klass, payload) {
    return this._buildJSONAPI(payload);
  },

  normalizeUpdateRecordResponse(store, klass, payload) {
    return this._buildJSONAPI(payload);
  }
});
