import Ember from 'ember';
import ApplicationSerializer from './application';

const { String: EmberString } = Ember;

export default ApplicationSerializer.extend({
  normalizeResponse(store, primaryModelClass, payload) {
    let camelCasePayload = {};
    camelCasePayload.id = payload.name.toLowerCase();

    // Convert from snake_case to camelCase
    Object.keys(payload).forEach(function (key) {
      camelCasePayload[EmberString.camelize(key)] = payload[key];
    });
    return {
      data: {
        id: camelCasePayload.id,
        type: 'product',
        attributes: camelCasePayload
      }
    };
  }
});
