/* global uuid */
import ApplicationSerializer from './application';
import { deserializeStream } from 'web-client/serializers/stream';

let _streamRelationship = (stream) => {
  return {
    type: 'stream',
    id: stream.channel.name
  };
};

export function deserializeRecentlyWatchedStreamsIncluded(recentlyWatchedStreams) {
  let included = [];

  recentlyWatchedStreams.forEach((stream) => {
    included.push(deserializeStream(stream));
  });

  return included;
}

export function deserializeRecentlyWatchedStreams(recentlyWatchedStreams) {
  return {
      id: uuid(),
      type: 'recently-watched-stream',
      relationships : {
        streams: {
          data: recentlyWatchedStreams.map((stream) => {
            return _streamRelationship(stream);
          })
        }
      }
    };
}

export default ApplicationSerializer.extend({
  normalizeQueryRecordResponse(store, type, payload) {

    let data = deserializeRecentlyWatchedStreams(payload.recently_watched_streams);
    let included = deserializeRecentlyWatchedStreamsIncluded(payload.recently_watched_streams);

    return this._super(store, type, {data, included});
  }
});
