/* globals _ */

import ApplicationSerializer from './application';

export function deserializeStream(payload) {
  let id = payload.channel.name;

  return {
    type: 'stream',
    id,
    attributes: _.omit(payload, ['channel']),
    relationships: {
      channel: {
        data: { type: 'channel', id }
      }
    }
  };
}

export default ApplicationSerializer.extend({
  normalizeFindRecordResponse(store, primaryModelClass, payload, id) {

    // If there is no stream available, set as offline
    let attributes = this.extractAttributes(primaryModelClass, { attributes: payload.stream || { is_offline: true } });
    this.applyTransforms(primaryModelClass, attributes);

    let data = {
      id,
      type: 'stream',
      attributes
    };

    return { data };
  }
});
