/* global uuid */
import JSONSerializer from 'ember-data/serializers/json';

export default JSONSerializer.extend({
  normalize(typeClass, resourceHash) {
    let response = this._super(...arguments);
    response.included = resourceHash.map((item) => {
      let video = this.store.normalize('video', item).data;
      video.id = item._id;
      return video;
    });
    return response;
  },

  normalizeQueryRecordResponse(store, type, payload) {
    return this._super(store, type, payload.trending_videos);
  },

  extractId() {
    return uuid();
  },

  extractRelationships(modelClass, resourceHash) {
    let itemData = !Array.isArray(resourceHash) ? [] : resourceHash.map((item) => {
      return {
        id: item._id,
        type: 'video'
      };
    });
    return { videos: { data: itemData }  };
  }
});
