import ApplicationSerializer from './application';

export default ApplicationSerializer.extend({
  _deserializeTopCommunities(payload) {
    let hash = {data: [], included: []};
    let data = payload.communities ? payload.communities : payload;
    data.forEach(function (community) {
      hash.data.push({
        type: 'twitch-community',
        attributes: community,
        id: community._id
      });
    });

    return hash;
  },

  normalizeQueryResponse(store, type, payload, id) {
    let hash = this._deserializeTopCommunities(payload);
    let meta = this.extractMeta(store, type, payload);
    hash.meta = meta;
    return this._super(store, type, hash, id);
  }
});
