import IMAPISerializer from 'web-client/serializers/im-api';

export default IMAPISerializer.extend({
  attrs: {
    lastMessageId: 'last_message_id',
    lastReadMessageId: 'last_read_message_id'
  },

  normalizeArrayResponse(store, modelClass, payload, id, requestType) {
    let normalized = {
      data: payload.data.map(unreadItem => {
        return {
          attributes: this._buildAttributes(unreadItem),
          id: unreadItem.id,
          type: 'unread'
        };
      }),
      meta: {
        totalUnreadMessages: payload.unread_messages,
        complete: payload.complete
      },
      links: payload.links
    };

    return this._super(store, modelClass, normalized, id, requestType);
  },

  _buildAttributes(hash) {
    return {
      last_read_message_id: hash.last_read_message_id,
      last_message_id: hash.last_message_id
    };
  }
});
