import ApplicationSerializer from './application';

let _deserialize = payload => {
  let id = payload.name; // in userData, this is `login`
  if (payload.logo === null) {
    delete payload.logo;
  }

  return {
    type: 'user',
    id,
    attributes: payload
  };
};

export default ApplicationSerializer.extend({
  normalizeFindRecordResponse(store, type, payload, id) {
    let data = _deserialize(payload);
    return this._super(store, type, { data }, id);
  },

  normalizeUpdateRecordResponse(store, type, payload, id) {
    let data = _deserialize(payload);
    return this._super(store, type, { data }, id);
  },

  normalizeResponse(store, type, payload, id, requestType) {
    if (!payload.follows) {
      return this._super(...arguments);
    }

    let meta = this.extractMeta(store, type, payload);

    // TODO follows will have to become something more general
    let data = payload.follows.map(follow => {
      return _deserialize(follow.user);
    });
    let hash = { data, meta };
    return this._super(store, type, hash, id, requestType);
  }
});
