## API service

The API service is an Ember-safe way to make `Twitch.api` calls. Internally
it is based on `Twitch.api` and it shares the same argument signature, but
the goal is to eventually have a refactored implementation.

Inject this service on a factory before use. For example:

```js
import Component from 'ember-component';
import injectService from 'ember-service/inject';

export default Component.extend({
  api: injectService(),
  click() {
    let api = this.get('api');
    api.request('get', 'https://some.twitch.tv/url');
  }
});
```

### `api.request`

`request` can make a request to Twitch's servers efficiently, without invoking
CORS preflights. The response is an Ember.RSVP.Promise.

```js
request(method, url, data, options); // => Ember.RSVP.Promise instance
```

The promise in turn will resolve with the data from jQuery's request, or reject
with the jQuery XHR object or an error object. For example:

```js
api.request('get', 'https://some.twith.tv/url', {}, {}).then(data => {
  console.log(data.someProperty);
}, error => {
  if (error instanceof Error) {
    throw error;
  }
  console.log('Failed XHR with ', error.status);
});
```

Valid methods are `get`, `post`, `del`, and `put`. `options` are largely
passed to `jQuery.ajax`, however there is some modification before
they are used.
