## Tracking Service

The tracking service sends event metrics to the various analytics services 
that Twitch uses for performance and health monitoring.

Inject this service using Ember's DI APIs:

```js
import Component from 'ember-component';
import injectService from 'ember-service/inject';

export default Component.extend({
  tracking: injectService()
});
```

Over time, this service should replace much of the `Twitch.tracking` API
namespace. It already replaces calling `trackEvent()` as a method call for 
`Twitch.tracking.spade`, `Twitch.tracking.mixpanel`, & `Twitch.tracking.spadeAndMixpanel`.

### Template Usage

Any of the below methods can be triggered directly from a template, 
as long as the `tracking` service has been injected into that template's context.

```handlebars
<button {{action 'trackEvent' config target='tracking'}}
```

You can even use the action helper to pass it into a component:

```handlebars
{{my-component someAction=(action 'trackEvent' target=tracking)}}
```

The component can then invoke that action internally as it would any other action:

```js
this.get('someAction')({ /*...config...*/ });
```

### `trackEvent`

This method sends an event to one or more analytics services. 
It takes in a single `config` object that contains the event name and 
its data, as well as an optional list of service names to send the event to. 
If no names are provides, the event will be sent to all available services.

```js
// send event to all services
this.get('tracking').trackEvent({
  event: 'theatre_mode',
  data: {
    state: 'enabled'
  }
});
```

To specify which services to report this event to, include a `services` array:

```js
// send event to mixpanel only
this.get('tracking').trackEvent({
  services: ['mixpanel'],
  event: 'theatre_mode',
  data: {
    state: 'enabled'
  }
});
```

### `trackChannelEvent`

This method is used for tracking channel events, such as a user clicking the 'follow' button. 
In addition to the event and data, the channel model must be passed as separate parameters.

```js
this.get('tracking').trackEvent('follow', this.get('model'), {
  // some data...
});
```
