import Service from 'ember-service';
import injectService from 'ember-service/inject';

/*
  Bounties Service.

  Responsible for loading data about bounties.
*/
const CONTENT_TYPE = 'application/json; charset=UTF-8';

export default Service.extend({
  api: injectService(),
  tracking: injectService(),

  getStreamlineBounties(channelId) {
    let options = { contentType: CONTENT_TYPE };
    return this.get('api')
      .authRequest('get', `/v5/broadcaster/${ channelId }/amendment/streamline`, null, options);
  },

  setStreamlineAmendmentAccepted(channelId) {
    let jsonData = JSON.stringify({
      amendment_accepted: true
    });
    let options = {
      contentType: CONTENT_TYPE,
      processData: false
    };
    return this.get('api')
      .authRequest('put', `/v5/broadcaster/${ channelId }/amendment/streamline`, jsonData, options);
  },

  getGameCommerceAmendmentAcceptance(channelId) {
    let options = { contentType: CONTENT_TYPE };
    return this.get('api')
      .authRequest('get', `/v5/broadcaster/${ channelId }/amendment/game_commerce`, null, options);
  },

  setGameCommerceAmendmentAcceptance(channelId) {
    let jsonData = JSON.stringify({
      amendment_accepted: true
    });
    let options = {
      contentType: CONTENT_TYPE,
      processData: false
    };
    return this.get('api')
      .authRequest('put', `/v5/broadcaster/${ channelId }/amendment/game_commerce`, jsonData, options);
  }
});
