import injectService from 'ember-service/inject';
import Service from 'ember-service';

const EXPERIMENT_NAME = 'BROWSE_EXPERIMENT';

export default Service.extend({
  experiments: injectService(),

  isBrowseExperimentEnabled: false,
  isBrowseExperimentSubmenuEnabled: false,

  checkExperiment() {
    let experiments = this.get('experiments');
    return experiments.getExperimentValue(EXPERIMENT_NAME).then(value => {
      if (this.isDestroyed || value === undefined || value === 'control') { return; }

      this.set('isBrowseExperimentEnabled', true);

      // As of writing, both variants of the BROWSE_EXPERIMENT will now do
      // the same thing: the submenu will always be disabled.
      this.set('isBrowseExperimentSubmenuEnabled', false);
    });
  }
});
