import Service from 'ember-service';
import computed from 'ember-computed';
import SettingsModel from 'web-client/models/settings';

export default Service.extend({
  init() {
    this._super(...arguments);
    this.set('model', SettingsModel.findOne());
  },

  colorOptions: computed.readOnly('model.colorOptions'),

  darkMode: computed.alias('model.darkMode'),

  showMessageFlags: computed.alias('model.showMessageFlags'),

  showModerationActions: computed.alias('model.showModerationActions'),

  showTwitchBotActions: computed.alias('model.showTwitchBotActions'),

  showModIcons: computed.alias('model.showModIcons'),

  showTimestamps: computed.alias('model.showTimestamps'),

  lastUsedFollowerDurations: computed.alias('model.lastUsedFollowerDurations'),
  hasSeenFollowersNotification: computed.alias('model.hasSeenFollowersNotification'),

  setFollowerSelection(channel, value) {
    this.get('model').setFollowerSelection(channel, value);
    this.notifyPropertyChange('lastUsedFollowerDurations');
  },

  getFollowerSelection(channel) {
    return this.get('model').getFollowerSelection(channel);
  }
});
