import Service from 'ember-service';

export default Service.extend({
  DELIMETER: '+',

  init() {
    this._super(...arguments);
    this.outlets = {};
  },

  render(componentName, {sourceTemplateName, outlet, model}) {
    let componentForOutlet = {componentName};
    if (model) {
      componentForOutlet.model = model;
    }
    this.set(`outlets.${sourceTemplateName}${this.DELIMETER}${outlet}`, componentForOutlet);
  },

  disconnect({sourceTemplateName, outlet}) {
    this.set(`outlets.${sourceTemplateName}${this.DELIMETER}${outlet}`, null);
  }

});
