/* globals Twitch */

import Service from 'ember-service';
import { wrap } from 'web-client/utilities/promises';

export default Service.extend({
  init() {
    this._super(...arguments);
    this.values = {};
  },

  getExperimentValue(experimentName) {
    return wrap(
      () => Twitch.experiments.getExperimentValue(experimentName),
      'ExperimentService#getExperimentValue'
    ).then((value) => {
      this.values[experimentName] = value;
      return value;
    });
  },

  peekValue(experimentName) {
    return this.values[experimentName];
  }
});
