/* globals Twitch, SiteOptions */
import Service from 'ember-service';

import computed from 'ember-computed';
import { getIEVersion, getBrowserName } from 'web-client/utilities/user-agent';

const ieVersion = getIEVersion();
const browserName = getBrowserName();

export default Service.extend({
  // jscs:disable requireCamelCaseOrUpperCaseIdentifiers
  browserName: browserName,
  feedsPubsubEnv: SiteOptions.deploy_flavor === 'production' ? 'production' : 'darklaunch',
  isIE9OrLess: !!(ieVersion && ieVersion < 10),
  isUnsupportedBrowser: computed.readOnly('isIE9OrLess'), // TODO: Update this to include more browsers later
  useHashLocation: computed.readOnly('isIE9OrLess'),
  broadcasterLanguages: SiteOptions.broadcaster_languages,
  broadcastLanguageChatEnabled: SiteOptions.broadcast_language_chat_enabled,
  defaultBLCLanguages: SiteOptions.default_blc_languages,
  excludedLocalizedContentLanguages: ["en"],
  followingVideosEnabled: SiteOptions.following_videos,
  allowLoadMoreOnFollows: SiteOptions.load_more_on_follows,
  disableFollowsSidePanel: SiteOptions.disable_follows_side_panel,
  disableFollowingDirectory: SiteOptions.disable_following_directory,
  disableGroupChat: SiteOptions.disable_group_chat,
  enableHostMode: SiteOptions.enable_host_mode || Twitch.storage.getObject('secretlyEnableHostMode'),
  disableYoutubeExporter: SiteOptions.disable_youtube_exporter,
  isInMaintenanceMode: SiteOptions.maintenance_mode,
  isVodAppealsEnabled: SiteOptions.enable_vod_appeals,
  apiHostport: SiteOptions.api_hostport,
  playlistMoreInfo: SiteOptions.playlist_more_info,
  chatReplayMoreInfo: SiteOptions.chat_replay_more_info,
  isBitsEnabled: SiteOptions.is_bits_enabled,
  isBitsStaffOnlyBeta: SiteOptions.is_bits_staffonly_beta,
  AdsForBits: SiteOptions.ads_for_bits,
  purchaseBitsUrl: SiteOptions.purchase_bits_url,
  bitsProducts: SiteOptions.bits_products,
  dfpFpSizzlestrip: SiteOptions.dfp_fp_sizzlestrip,
  bitsEvoEnabledChannels: SiteOptions.bits_evo_enabled_channels,
  isFlDetailsLinkEnabled: SiteOptions.fl_details_link_enabled,
  isFlEnabled: SiteOptions.is_fl_enabled,
  flEnabledList: SiteOptions.fl_enabled_list,
  cmrcGameDetailsV2Released: SiteOptions.cmrc_game_details_v2_released,
  cmrcChannelBoxReleased: SiteOptions.cmrc_channel_box_released,
  cmrcKickKickBoomReleased: SiteOptions.cmrc_kick_kick_boom_released,
  bitsPromoEnabled: SiteOptions.bits_promo_enabled,
  pCheerEnabled: SiteOptions.p_cheer_enabled,
  primeBlackfridayPromoEnabled: SiteOptions.prime_blackfriday_promo_enabled,
  truexApiUrl : SiteOptions.truex_api_url,
  truexJsUrl : SiteOptions.truex_js_url,
  truexPartnerHash : SiteOptions.truex_partner_hash

  // jscs:enable requireCamelCaseOrUpperCaseIdentifiers
});
