/* global Twitch */
import initializeGoogletag from 'web-client/utilities/initialize-googletag';
import Service from 'ember-service';

// Here's the approach I'm mimicking since our content is dynamic:
//
// https://support.google.com/dfp_premium/answer/4578089#infiniteContents
export default Service.extend({
  init() {
    this._super(...arguments);
    this._googletag = initializeGoogletag();
    this.set('isBlocked', this._googletag.isBlocked);
  },

  createSlot() {
    return this._googletag.createSlot(...arguments);
  },

  refreshSlots() {
    this._googletag.refreshSlots(...arguments);
  },

  destroySlots() {
    this._googletag.destroySlots(...arguments);
  },

  destroySlot() {
    this._googletag.destroySlot(...arguments);
  },

  dfpAdUnitPathFor(name) {
    return `/${Twitch.ads.dfpNetworkCode}/twitch/${name}`;
  }
});
