import headData from 'ember-cli-head/services/head-data';
import ENV from 'web-client/config/environment';

/*
* Extends the headData service for Twitch-specific functionality
*/
export default headData.extend({
  googleSiteVerification: ENV.GOOGLE_SITE_VERIFICATION,
  googlePublisherTag: ENV.GOOGLE_PUBLISHER_TAG,

  /* Title Tag */
  title: '',
  setTitle(value, hasTwitchSuffix) {
    if (hasTwitchSuffix) {
      this.set('title', `${value} - Twitch`);
    } else {
      this.set('title', value);
    }
  },

  /* Canonical URL Link Tag */
  canonicalUrl: null,

  /*
  * See app/mixins/canonical-url-route.js for a mixin to use on Routes
  */
  clearCanonicalUrl() {
    this.set('canonicalUrl', '');
  }
});
