import Service from 'ember-service';
import injectService from 'ember-service/inject';

export default Service.extend({
  api: injectService(),

  getBitrate() {
    let api = this.get('api');
    let url = `/kraken/ingest/bitrate`;

    return api.authRequest('get', url);
  },

  getHealth({ channelID }) {
    let api = this.get('api');
    let url = `/kraken/channels/${ channelID }/ingest/health`;
    let options = { version: 5 };

    return api.authRequest('get', url, null, options);
  }
});
