import Service from 'ember-service';
import computed from 'ember-computed';

export default Service.extend({
  selected: null,

  isCommunitiesSelected: computed.equal('selected', 'Communities'),
  isGamesSelected: computed.equal('selected', 'Games'),
  isDiscoverySelected: computed.equal('selected', 'Discovery'),
  isPopularSelected: computed.equal('selected', 'Popular'),
  isChannelsSelected: computed.equal('selected', 'Channels'),
  isChannelSelected: computed.equal('selected', 'Channel'),
  isVideosSelected: computed.equal('selected', 'Videos'),
  isCreativeSelected: computed.equal('selected', 'Creative'),
  isFollowingSelected: computed.equal('selected', 'Following'),
  isBackpackSelected: computed.equal('selected', 'Backpack'),
  isDashboardSelected: computed.equal('selected', 'Dashboard'),
  isManagerSelected: computed.equal('selected', 'Manager'),
  isDrawerOpen: false,

  isBrowseSelected: computed.or('isGamesSelected', 'isPopularSelected', 'isDiscoverySelected'),

  setSelected(selected) {
    this.set('selected', selected ? selected : null);
  }
});
