/* globals Twitch */
import Service from 'ember-service';
import injectService from 'ember-service/inject';

export default Service.extend({
  api: injectService(),
  store: injectService(),
  session: injectService(),
  tracking: injectService(),

  getGamesNewReleases(userLanguages) {
    let deviceId = Twitch.idsForMixpanel.getOrCreateUniqueId();
    let store = this.get('store');
    let query = {
      language: userLanguages.join(','),
      device_id: deviceId
    };
    return store.query('game-new-release', query).then((gamesNewReleases) => {
      if (this.isDestroyed) { return; }
      return gamesNewReleases.sortBy();
    });
  }
});
