import Service from 'ember-service';

import PhoenixLib from 'npm:twitch-phoenix';

// The way in which we build our PhoenixLib doesn't seem to play nicely with
// Ember's import system. Revisit trying to get named exports working with
// standard ES6 destructuring syntax.
const Phoenix = PhoenixLib.Phoenix;

export default Service.extend({
  init() {
    this._super(...arguments);

    // Hydrate the store here by providing data from other ember services as an argument.
    // Do not use the store directly. Instead, add a method for dispatching.
    this.set('_store', Phoenix.createStore());
  },

  setUser(user) {
    let { setUser } = Phoenix.actionCreators;
    this.get('_store').dispatch(setUser(user));
  }
});
