import Service from 'ember-service';
import injectService from 'ember-service/inject';
import RSVP from 'rsvp';

export default Service.extend({
  api: injectService(),
  store: injectService(),
  session: injectService(),
  tracking: injectService(),

  getRecentlyWatchedStreams() {
    let store = this.get('store');
    let {isAuthenticated, userData} = this.get('session');
    if (!isAuthenticated) {
      return RSVP.resolve([]);
    }
    return store.queryRecord('recently-watched-stream', {
      oauth_token: userData.chat_oauth_token
    }).then((recentlyWatchedStream) => {
      if (this.isDestroyed) { return []; }
      return recentlyWatchedStream.get('streams');
    });
  }
});
