import Service from 'ember-service';
import Ember from 'ember';

const { inject } = Ember;

export default Service.extend({
  api: inject.service(),

  queryPermission: function (query) {
    let url = `/api/rechat/delete/${query.messageId}?channel_id=${query.id}`,
        headers = {'Permitted-Actions': true};

    // This API does not return the passed in channel_id, we need to set it explicitly
    return this.get('api').request('del', url, {}, {headers}).then(response => {
      return response.permitted_actions.moderate_channel;
    }, error => {
      if (error.status === 401) {
        return false;
      }
      throw error;
    });
  }
});
