/* globals Twitch */
import Service from 'ember-service';

export default Service.extend({
  unknownProperty(key) {
    return Twitch.storage.get(key);
  },

  setUnknownProperty(key, value) {
    if (key.indexOf('.') > -1) {
      console.warn('Use `-` as a delimiter in your key. Do not use `.`!');
    }
    this.propertyWillChange(key);
    Twitch.storage.set(key, value);
    this.propertyDidChange(key);

    return Twitch.storage.get(key);
  }
});
