import Service from 'ember-service';
import injectService from 'ember-service/inject';

export const VERSION = 1;

export default Service.extend({
  api: injectService(),

  init() {
    this._super(...arguments);

    this.prefix = `/subscriptions/v${VERSION}`;
  },

  getBadges({ channelID }) {
    let api = this.get('api');
    let url = `${this.prefix}/channels/${channelID}/badges`;

    return api.request('get', url);
  },

  createBadge({ channelID, formData }) {
    let api = this.get('api');
    let url = `${this.prefix}/channels/${channelID}/badges`;
    let options = {
      contentType: false,
      processData: false
    };

    return api.request('post', url, formData, options);
  },

  deleteBadge({ channelID, badgeID }) {
    let api = this.get('api');
    let url = `${this.prefix}/channels/${channelID}/badges/${badgeID}`;

    return api.request('delete', url);
  },

  getTimeoutStatuses({ channelID }) {
    let api = this.get('api');
    let url = `${this.prefix}/channels/${channelID}/timeout_statuses`;

    return api.request('get', url);
  },

  getSubscriberCount({ channelLogin }) {
    let api = this.get('api');
    let url = `/api/channels/${ channelLogin }/subscriber_count`;

    return api.request('get', url);
  }
});
