import Service from 'ember-service';
import DeprecatedVideo from 'web-client/models/deprecated-video';
import injectService from 'ember-service/inject';
import { UPLOAD_TYPE_PARAM } from 'web-client/utilities/video/types';
import { SORT_TRENDING_V3_TYPE } from 'web-client/utilities/video/sorts';

export default Service.extend({
  recommendationLanguages: injectService(),

  getTrendingUploads(game) {
    let recommendationLanguages = this.get('recommendationLanguages');
    return recommendationLanguages.getRecommendationLanguages().then((languages) => {
      if (this.isDestroyed) { return []; }
      let opts = {
        game: game,
        sort: SORT_TRENDING_V3_TYPE,
        period: 'week',
        broadcastType: UPLOAD_TYPE_PARAM,
        language: languages.join(','),
        useHigherLimit: true
      };
      return DeprecatedVideo.find('game', opts).load(true);
    });
  }
});
