import Service from 'ember-service';
import injectService from 'ember-service/inject';

export default Service.extend({
  api: injectService(),
  store: injectService(),
  session: injectService(),
  tracking: injectService(),

  getTrendingVideos(userLanguages) {
    let store = this.get('store');
    let query = {
      language: userLanguages.join(',')
    };
    return store.queryRecord('trending-video', query).then((trendingVideo) => {
      if (this.isDestroyed) { return []; }
      return trendingVideo.get('videos');
    });
  }
});
