import AjaxService from 'ember-ajax/services/ajax';
import { assign } from 'ember-platform';

const DEFAULT_OPTIONS = {
  global: false,
  dataType: 'json',
  headers: {},
  xhrFields: {}
};

/**
 * Twitch Clips backend.
 *
 * Supports making CORS powered GETs on clips.twitch.tv/api/
 * JSONP is not supported, therefore IE9 and below are not supported.
 */
export default AjaxService.extend({
  host: 'https://clips.twitch.tv/',
  namespace: '/api/v1',

  request(url, _options={}) {
    let options = {};

    assign(options, DEFAULT_OPTIONS);
    assign(options, _options);

    return this._super(url, options);
  }
});
