import computed from 'ember-computed';
import AjaxService from 'web-client/services/twitch-friends-list/backend/ajax';
import injectService from 'ember-service/inject';

export default AjaxService.extend({
  globals: injectService(),
  session: injectService(),

  baseUrl: computed(function() {
    return `https://${this.get('globals.apiHostport')}/kraken/users/${this.get('session.userData.login')}/friends`;
  }),

  request(url, options) {
    url = url || '';
    url = this.get('baseUrl') + url;
    return this._super(url, options);
  }
});
