import AjaxService from 'web-client/services/twitch-presence/backend/ajax';
import { presenceHost } from 'web-client/utilities/presence-util';
import injectService from 'ember-service/inject';

export default AjaxService.extend({
  baseUrl: presenceHost,
  namespace: 'v2',
  presence: injectService('twitch-presence/presence'),

  isPolling: false,

  request(url, options) {
    return this._super(`${this.get('baseUrl')}/${this.get('namespace')}/${url || ''}`, options);
  },

  setPresence(activity, presence) {
    let sessionId = this.get('presence.sessionId');
    this._request('online', {
      type: 'POST',
      data: {
        session_id: sessionId,
        availability: presence || 'online',
        activity: activity || null
      }
    });
  }
});
