import RSVP from 'rsvp';
import Service from 'ember-service';
import injectService from 'ember-service/inject';
import env from 'web-client/config/environment';

export default Service.extend({
  api: injectService(),
  session: injectService(),

  getPlatformForChannel(channel) {
    channel = channel.toLowerCase();
    return env.vhsConnections.find(platform => {
      return platform.channels.includes(channel);
    });
  },

  getPlatformById(platformId) {
    return env.vhsConnections.find(platform => {
      return platform.id === platformId;
    });
  },

  isCurrentUserLinkedToPlatform(platformId) {
    let api = this.get('api');
    let platform = this.getPlatformById(platformId);

    if (!this.get('session.isAuthenticated') || !platform) {
      return RSVP.resolve(false);
    }

    return api.authRequest('get', `/v5/connections/vhs/${platform.id}`, '', {
      headers: {
        'Client-ID': platform.clientId
      }
    }).then(() => true, () => false);
  }
});
