import injectService from 'ember-service/inject';
import Service from 'ember-service';

const EXPERIMENT_NAME = 'VODS_GAME_INFO';

export default Service.extend({
  experiments: injectService(),

  isUnwatchedBoxartViewable: false,
  isTextViewable: false,

  checkExperiment() {
    let experiments = this.get('experiments');
    return experiments.getExperimentValue(EXPERIMENT_NAME).then(value => {
      let isUnwatchedBoxartViewable = (value === 'boxart_unwatched');
      this.set('isUnwatchedBoxartViewable', isUnwatchedBoxartViewable);

      let isTextViewable = (value === 'text_no_desc');
      this.set('isTextViewable', isTextViewable);
    });
  }
});
