import Ember from "ember";
const { testing } = Ember;

export default function() {
  let duration = 200;
  if (testing) {
    this.setDefault({duration: 10});
  }

  this.transition(
    this.hasClass("to-left-reverse-to-right"),
    this.toValue(true),
    this.use('toLeft', {duration: duration}),
    this.reverse('toRight', {duration: duration})
  );

  this.transition(
    this.hasClass("to-right-reverse-to-left"),
    this.toValue(true),
    this.use('toRight', {duration: duration}),
    this.reverse('toLeft', {duration: duration})
  );

  this.transition(
    this.hasClass("fade-reverse-fade"),
    this.toValue(true),
    this.use('fade', {duration: 400}),
    this.reverse('fade', {duration: 400})
  );

  this.transition(
    this.hasClass("to-down-reverse-to-down"),
    this.toValue(true),
    this.use('toDown', {duration: duration}),
    this.reverse('toDown', {duration: duration})
  );

  this.transition(
    this.hasClass("to-up-reverse-to-down"),
    this.toValue(true),
    this.use('toUp', {duration: duration}),
    this.reverse('toDown', {duration: duration})
  );

  this.transition(
    this.hasClass("to-right-reverse-to-left-pinned-cheers"),
    this.toValue(true),
    this.use('toRight', {duration: 400, easing: "easeInOut"}),
    this.reverse('toLeft', {duration: 400, easing: "easeInOut"})
  );
}
