import Ember from 'ember';
import config from 'web-client/config/environment';
const { run, RSVP } = Ember;

const ANIMATE_OUT_TIME = config.fastAnimations ? 0 : 300;

export default function() {
  return this.newElement ? animateIn(this.newElement) : animateOut(this.oldElement);
}

function animateIn(el) {
  el.css('visibility', 'visible');
  el.addClass('smallBounceIn');
}

function animateOut(el) {
  el.addClass('smallBounceOut');

  return new RSVP.Promise((resolve) => {
    run.later(resolve, ANIMATE_OUT_TIME);
  });
}
