import {
  HASHTAG_REGEXES
} from 'web-client/utilities/bits/constants-config';

export function isValidHashtagMessage(message = '') {
  let words = message.split(/\s+/);
  return words.some((word) => { return HASHTAG_REGEXES.VALID.test(word); });
}

export function getHashtagFromMessage(message = '') {
  let words = message.split(/\s+/);
  for (let i = 0; i < words.length; i++) {
    if (HASHTAG_REGEXES.VALID.test(words[i])) {
      return words[i].match(HASHTAG_REGEXES.VALID)[0];
    }
  }

  return '';
}
