/**
 * Variety of constants related to Bits.
 *
 * Centralized here for application-wide consistency and use in tests.
 */
export const TIMINGS = {
  ERROR_DISPLAY_TIMEOUT: 5000, // duration of error messages on bad send attempt and API errors
  GET_BALANCE_RATE_LIMIT: 5000,
  UNDO_PROMPT_DURATION: 5000
};

export const HASHTAG_REGEXES = {
  VALID: /^\s*#\S+\s*$/i
};

export const PINNED_CHEER_TYPES = {
  TOP: 'top',
  RECENT: 'recent'
};

export const CHEER_PREFIX = 'Cheer';
export const CHEERMOTE_BG_DARK = 'dark';
export const CHEERMOTE_BG_LIGHT = 'light';
export const MAX_BITS_EMOTE = 10000;
export const MAX_BITS_MESSAGE_LENGTH = 500; // TODO: Parity with TMI (500 go runes)
export const SEND_WITH_DELAY_MINIMUM = 1000; // Amount of Bits that will trigger an undo prompt/delay on send
export const LOCALSTORAGE_KEYS = {
  SEEN_PROMO_PREFIX: 'twitch.bits.promoSeenV2',
  SEEN_EVO_PROMO_PREFIX: 'twitch.bits.evoPromoSeen',
  SEEN_ADS_PROMO_PREFIX: 'twitch.bits.adsPromoSeen',
  SEEN_ELIGIBLE_NOTIFICATION_PREFIX: 'twitch.bits.eligibleNotificationSeen',
  SEEN_PCHEER_BROADCASTER_NOTIFICATION: 'bits-notification-seen-pinned-broadcaster',
  SEEN_PCHEER_VIEWER_NOTIFICATION: 'bits-notification-seen-pinned-viewer'
};

export const FALLBACK_BITS_ACTIONS = {
  actions: [{
     "prefix": "Cheer",
     "scales": [1, 1.5, 2, 3, 4],
     "backgrounds": ["light", "dark"],
     "states": ["static", "animated"],
     "tiers": [{
         "min_bits": 1,
         "id": "1",
         "color": "#979797",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/1/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/1/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/1/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/1/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/1/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/1/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/1/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/1/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/1/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/1/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/1/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/1/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/1/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/1/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/1/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/1/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/1/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/1/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/1/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/1/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 100,
         "id": "100",
         "color": "#9c3ee8",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/100/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/100/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/100/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/100/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/100/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/100/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/100/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/100/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/100/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/100/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/100/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/100/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/100/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/100/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/100/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/100/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/100/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/100/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/100/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/100/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 1000,
         "id": "1000",
         "color": "#1db2a5",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/1000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/1000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/1000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/1000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/1000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/1000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/1000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/1000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/1000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/1000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/1000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/1000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/1000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/1000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/1000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/1000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/1000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/1000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/1000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/1000/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 5000,
         "id": "5000",
         "color": "#0099fe",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/5000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/5000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/5000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/5000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/5000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/5000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/5000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/5000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/5000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/5000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/5000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/5000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/5000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/5000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/5000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/5000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/5000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/5000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/5000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/5000/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 10000,
         "id": "10000",
         "color": "#f43021",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/10000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/10000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/10000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/10000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/static/10000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/10000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/10000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/10000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/10000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/light/animated/10000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/10000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/10000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/10000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/10000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/static/10000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/10000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/10000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/10000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/10000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/cheer/dark/animated/10000/4.gif"
                 }
             }
         }
     }]
 }, {
     "prefix": "Kreygasm",
     "scales": [1, 1.5, 2, 3, 4],
     "backgrounds": ["light", "dark"],
     "states": ["static", "animated"],
     "tiers": [{
         "min_bits": 1,
         "id": "1",
         "color": "#979797",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/1/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/1/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/1/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/1/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/1/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/1/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/1/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/1/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/1/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/1/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/1/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/1/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/1/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/1/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/1/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/1/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/1/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/1/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/1/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/1/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 100,
         "id": "100",
         "color": "#9c3ee8",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/100/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/100/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/100/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/100/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/100/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/100/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/100/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/100/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/100/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/100/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/100/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/100/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/100/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/100/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/100/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/100/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/100/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/100/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/100/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/100/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 1000,
         "id": "1000",
         "color": "#1db2a5",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/1000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/1000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/1000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/1000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/1000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/1000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/1000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/1000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/1000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/1000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/1000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/1000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/1000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/1000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/1000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/1000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/1000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/1000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/1000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/1000/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 5000,
         "id": "5000",
         "color": "#0099fe",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/5000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/5000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/5000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/5000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/5000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/5000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/5000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/5000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/5000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/5000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/5000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/5000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/5000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/5000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/5000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/5000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/5000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/5000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/5000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/5000/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 10000,
         "id": "10000",
         "color": "#f43021",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/10000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/10000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/10000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/10000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/static/10000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/10000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/10000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/10000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/10000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/light/animated/10000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/10000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/10000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/10000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/10000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/static/10000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/10000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/10000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/10000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/10000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kreygasm/dark/animated/10000/4.gif"
                 }
             }
         }
     }]
 }, {
     "prefix": "Kappa",
     "scales": [1, 1.5, 2, 3, 4],
     "backgrounds": ["light", "dark"],
     "states": ["static", "animated"],
     "tiers": [{
         "min_bits": 1,
         "id": "1",
         "color": "#979797",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/1/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/1/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/1/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/1/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/1/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/1/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/1/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/1/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/1/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/1/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/1/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/1/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/1/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/1/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/1/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/1/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/1/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/1/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/1/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/1/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 100,
         "id": "100",
         "color": "#9c3ee8",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/100/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/100/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/100/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/100/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/100/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/100/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/100/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/100/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/100/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/100/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/100/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/100/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/100/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/100/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/100/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/100/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/100/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/100/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/100/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/100/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 1000,
         "id": "1000",
         "color": "#1db2a5",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/1000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/1000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/1000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/1000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/1000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/1000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/1000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/1000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/1000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/1000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/1000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/1000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/1000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/1000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/1000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/1000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/1000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/1000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/1000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/1000/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 5000,
         "id": "5000",
         "color": "#0099fe",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/5000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/5000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/5000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/5000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/5000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/5000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/5000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/5000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/5000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/5000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/5000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/5000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/5000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/5000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/5000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/5000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/5000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/5000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/5000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/5000/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 10000,
         "id": "10000",
         "color": "#f43021",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/10000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/10000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/10000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/10000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/static/10000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/10000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/10000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/10000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/10000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/light/animated/10000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/10000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/10000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/10000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/10000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/static/10000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/10000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/10000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/10000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/10000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/kappa/dark/animated/10000/4.gif"
                 }
             }
         }
     }]
 }, {
     "prefix": "Muxy",
     "scales": [1, 1.5, 2, 3, 4],
     "backgrounds": ["light", "dark"],
     "states": ["static", "animated"],
     "tiers": [{
         "min_bits": 1,
         "id": "1",
         "color": "#979797",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/1/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/1/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/1/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/1/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/1/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/1/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/1/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/1/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/1/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/1/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/1/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/1/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/1/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/1/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/1/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/1/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/1/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/1/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/1/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/1/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 100,
         "id": "100",
         "color": "#9c3ee8",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/100/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/100/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/100/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/100/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/100/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/100/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/100/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/100/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/100/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/100/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/100/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/100/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/100/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/100/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/100/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/100/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/100/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/100/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/100/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/100/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 1000,
         "id": "1000",
         "color": "#1db2a5",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/1000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/1000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/1000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/1000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/1000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/1000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/1000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/1000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/1000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/1000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/1000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/1000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/1000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/1000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/1000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/1000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/1000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/1000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/1000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/1000/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 5000,
         "id": "5000",
         "color": "#0099fe",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/5000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/5000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/5000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/5000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/5000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/5000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/5000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/5000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/5000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/5000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/5000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/5000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/5000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/5000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/5000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/5000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/5000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/5000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/5000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/5000/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 10000,
         "id": "10000",
         "color": "#f43021",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/10000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/10000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/10000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/10000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/static/10000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/10000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/10000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/10000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/10000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/light/animated/10000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/10000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/10000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/10000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/10000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/static/10000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/10000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/10000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/10000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/10000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/muxy/dark/animated/10000/4.gif"
                 }
             }
         }
     }]
 }, {
     "prefix": "Streamlabs",
     "scales": [1, 1.5, 2, 3, 4],
     "backgrounds": ["light", "dark"],
     "states": ["static", "animated"],
     "tiers": [{
         "min_bits": 1,
         "id": "1",
         "color": "#979797",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/1/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/1/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/1/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/1/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/1/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/1/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/1/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/1/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/1/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/1/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/1/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/1/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/1/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/1/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/1/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/1/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/1/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/1/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/1/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/1/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 100,
         "id": "100",
         "color": "#9c3ee8",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/100/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/100/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/100/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/100/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/100/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/100/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/100/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/100/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/100/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/100/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/100/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/100/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/100/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/100/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/100/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/100/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/100/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/100/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/100/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/100/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 1000,
         "id": "1000",
         "color": "#1db2a5",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/1000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/1000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/1000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/1000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/1000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/1000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/1000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/1000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/1000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/1000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/1000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/1000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/1000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/1000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/1000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/1000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/1000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/1000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/1000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/1000/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 5000,
         "id": "5000",
         "color": "#0099fe",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/5000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/5000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/5000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/5000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/5000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/5000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/5000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/5000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/5000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/5000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/5000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/5000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/5000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/5000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/5000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/5000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/5000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/5000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/5000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/5000/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 10000,
         "id": "10000",
         "color": "#f43021",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/10000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/10000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/10000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/10000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/static/10000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/10000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/10000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/10000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/10000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/light/animated/10000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/10000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/10000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/10000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/10000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/static/10000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/10000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/10000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/10000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/10000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/streamlabs/dark/animated/10000/4.gif"
                 }
             }
         }
     }]
 }, {
     "prefix": "SwiftRage",
     "scales": [1, 1.5, 2, 3, 4],
     "backgrounds": ["light", "dark"],
     "states": ["static", "animated"],
     "tiers": [{
         "min_bits": 1,
         "id": "1",
         "color": "#979797",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/1/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/1/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/1/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/1/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/1/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/1/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/1/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/1/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/1/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/1/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/1/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/1/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/1/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/1/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/1/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/1/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/1/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/1/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/1/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/1/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 100,
         "id": "100",
         "color": "#9c3ee8",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/100/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/100/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/100/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/100/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/100/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/100/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/100/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/100/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/100/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/100/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/100/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/100/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/100/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/100/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/100/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/100/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/100/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/100/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/100/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/100/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 1000,
         "id": "1000",
         "color": "#1db2a5",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/1000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/1000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/1000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/1000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/1000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/1000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/1000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/1000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/1000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/1000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/1000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/1000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/1000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/1000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/1000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/1000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/1000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/1000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/1000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/1000/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 5000,
         "id": "5000",
         "color": "#0099fe",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/5000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/5000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/5000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/5000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/5000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/5000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/5000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/5000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/5000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/5000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/5000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/5000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/5000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/5000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/5000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/5000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/5000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/5000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/5000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/5000/4.gif"
                 }
             }
         }
     }, {
         "min_bits": 10000,
         "id": "10000",
         "color": "#f43021",
         "images": {
             "light": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/10000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/10000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/10000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/10000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/static/10000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/10000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/10000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/10000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/10000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/light/animated/10000/4.gif"
                 }
             },
             "dark": {
                 "static": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/10000/1.png",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/10000/1.5.png",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/10000/2.png",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/10000/3.png",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/static/10000/4.png"
                 },
                 "animated": {
                     "1": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/10000/1.gif",
                     "1.5": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/10000/1.5.gif",
                     "2": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/10000/2.gif",
                     "3": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/10000/3.gif",
                     "4": "https://d3aqoihi2n8ty8.cloudfront.net/actions/swiftrage/dark/animated/10000/4.gif"
                 }
             }
         }
     }]
 }]
};
