/*
  Scans for cheer prefixes in the message parameter and returns the total number of bits being sent.
*/
export function parseTotalBits(message = '', regexes) {
  let words = message.split(/\s+/);
  let totalBits = 0;

  words.forEach(function (word) {
    let match = regexes.some(regex => {
      return word.match(regex.valid);
    });

    if(match) {
      let number = word.match(/\d+/);
      totalBits += parseInt(number, 10);
    }
  });

  return totalBits;
}
