/* globals SiteOptions */
import moment from 'moment';

let chatStickyExperiments, nativeBroadcastsExperiment, altRolesExperiment, viewingPartiesExperiment;

try {
  chatStickyExperiments = JSON.parse(SiteOptions.chat_sticky_experiment);
  nativeBroadcastsExperiment = chatStickyExperiments['native_broadcasts_experiment'];
  altRolesExperiment = chatStickyExperiments['alt_roles_experiment'];
  viewingPartiesExperiment = chatStickyExperiments['viewing_parties_experiment'];
} catch (e) {
  console.error(`${e} -- chat_sticky_experiment not valid JSON`);
}

function inDateRange(start, end) {
  let startTime = moment.utc([
    start.year,
    start.month,
    start.day,
    start.hour,
    start.minute,
    start.second
  ]);
  let endTime = moment.utc([
    end.year,
    end.month,
    end.day,
    end.hour,
    end.minute,
    end.second
  ]);

  return moment.utc().isBetween(startTime, endTime);
}

export {
  nativeBroadcastsExperiment,
  altRolesExperiment,
  viewingPartiesExperiment,
  inDateRange
};
