// Only accommodates string with one link - will need rework to accommodate multiple links
export function _chunkString(str, regex, link) {
  let strMatch = str.match(regex);
  if (!strMatch) {
    return null;
  }
  /**
    Will always result in 3 piece string:
    - (non-)empty first half
    - matched string to be wrapped with link
    - (non-)empty second half
  */
  let chunkedStr = str.split(strMatch[0]);
  return {
    firstHalf: chunkedStr[0],
    secondHalf: chunkedStr[1],
    wrappedString: strMatch[0],
    link: link || strMatch[0]
  };
}

export function chunkForTwitchPrimeSub(str, channelName) {
  let tpRegex = /Twitch Prime/;
  let href = `https://twitch.amazon.com/prime?ref=subscriptionMessage&channel=${channelName}`;
  return _chunkString(str, tpRegex, href);
}

export function chunkForUrl(str) {
  let urlRegex = /(?:https?:\/\/)?(?:[-a-zA-Z0-9@:%_\+~#=]+\.)+[a-z]{2,6}\b(?:[-a-zA-Z0-9@:%_\+.~#?&//=]*)/g;
  return _chunkString(str, urlRegex);
}
