import computed from 'ember-computed';

/*
  Ember.computed.equal can only check equivalence on a dependentKey with a static value.
  This utility allows you to check equivalence on two dependentKeys.
*/
export default function (a, b) {
  return computed(a, b, {
    get: function () {
      return this.get(a) === this.get(b);
    }
  });
}
