/**
 * Gets a fixed-position element's coordinates as if it were absolutely positioned
 * assumes the element would be absolutely positioned in the context of its immediate parent
 */
export function getAbsoluteElementPosition(element) {
  let parentElement = element.parent();
  let parentOffset = parentElement.offset();
  let elementPosition = element.position();

  let absTop = elementPosition.top - parentOffset.top + parentElement.scrollTop();
  let absLeft = elementPosition.left - parentOffset.left;

  return {
    top: absTop,
    left: absLeft
  };
}

/**
 * Gets an absolutely-positioned element's coordinates as if it were in fixed position
 * assumes the element is positioned in the context of its immediate parent
 */
export function getFixedElementPosition(element) {
  let elementPosition = element.position();

  let fixedTop = elementPosition.top;
  let fixedLeft = element.offset().left;

  return {
    top: fixedTop,
    left: fixedLeft
  };
}
