// Return a new custom Error
export function buildError(name, init=() => {}) {
  let CustomError = function() {
    Error.call(this);
    this.name = name;
    init(this);
    return this;
  };
  CustomError.prototype = Object.create(Error.prototype, {
    constructor: { value: CustomError }
  });
  return CustomError;
}

// CancellationError used for cancelling a Promise
export const CancellationError = buildError('cancellation');

export const UnauthenticatedError = buildError('unauthenticated', i => i.status = 401);

export const RequestAbortedError = buildError('RequestAbortedError: a network request was aborted by the user');
