/* globals i18n */

const WHISPERED_MESSAGE = i18n("You've whispered them");
const BILATERAL_FOLLOW_MESSAGE = i18n("You follow each other");
const HOSTED_MESSAGE = i18n("You've hosted them");
const CHAT_MENTIONED_MESSAGE = i18n("You've @mentioned them");
const ACTIVE_IN_SAME_CHANNELS_MESSAGE = i18n("You're active in the same channels");
const MOD_IN_SAME_CHANNELS_MESSAGE = i18n("You mod the same channels");
const TEAM_MESSAGE = i18n("You're on the same team");

export function getRecommendedReason(reason) {
  switch (reason) {
    case 'whispered':
      return WHISPERED_MESSAGE;
    case 'bilateral_follow':
      return BILATERAL_FOLLOW_MESSAGE;
    case 'hosted':
      return HOSTED_MESSAGE;
    case 'chat_mentioned':
      return CHAT_MENTIONED_MESSAGE;
    case 'active_in_same_channels':
      return ACTIVE_IN_SAME_CHANNELS_MESSAGE;
    case 'mod_in_same_channels':
      return MOD_IN_SAME_CHANNELS_MESSAGE;
    case 'team':
      return TEAM_MESSAGE;
  }
  return null;
}

const MOD = i18n("Your channel moderator");
const STAFF = i18n("Twitch Staff");
const PARTNER = i18n("Partner");
const ADMIN = i18n("Twitch Admin");
const GLOBAL_MOD = i18n("Global Moderator");

export function getNonStrangerReason(reason) {
  switch (reason) {
    case 'mod':
      return MOD;
    case 'staff':
      return STAFF;
    case 'partner':
      return PARTNER;
    case 'admin':
      return ADMIN;
    case 'global_mod':
      return GLOBAL_MOD;
  }
  return null;
}
