import computed from 'ember-computed';
import getOwner from 'ember-owner/get';

/**
 *
 * As we migrate views & controllers to components, we'd like to
 * temporarily inject controllers into `Component`s as part of the
 * migration path. Use as follows:
 *
 * export default Component.extend({
 *   layoutController: injectController('layout'),
 *   ...
 * });
 *
 * We'll remove this once we migrate the controllers to services.
 **/
export default function (controllerName) {
  return computed(function (propName) {
    let name = controllerName || propName;
    return getOwner(this).lookup(`controller:${name}`);
  });
}
