/**
 * Utility functions which can be used to compose a route's isInteractive definition
 */

export function isFollowingColumnInteractive(interactiveComponents) {
  let rightColumnRendered = interactiveComponents['directory/right-column'];
  let rightFollowingColumnRendered = interactiveComponents['directory/right-column/following'];
  let watchNowExperimentRendered = interactiveComponents['directory/right-column/watch-now'];
  let followingDirectoryDisabledEmptyOrNotLoggedIn = interactiveComponents['directory/right-column/following/disabled'] || interactiveComponents['directory/right-column/following/no-follows'] || interactiveComponents['directory/right-column/following/no-login'];
  let followedItemRendered = interactiveComponents['directory/right-column/vertical-stream-list-item'] || interactiveComponents['directory-following-offline'];

  if (rightColumnRendered) {
    if (watchNowExperimentRendered) {
      return true;
    }
    if (rightFollowingColumnRendered) {
      if (followingDirectoryDisabledEmptyOrNotLoggedIn) {
        return true;
      }
      // Convenience here because we know if a user doesn't have either of these then they're not following anyone
      if (followedItemRendered) {
        return true;
      }
    }
  }
  return false;
}

export function isFollowingChannelsDirectoryInteractive(interactiveComponents) {
  return interactiveComponents['stream-preview'] || interactiveComponents['beacon:following-directory-no-live-channels'] || interactiveComponents['directory-following-none'];
}


export function isFollowingHostsDirectoryInteractive(interactiveComponents) {
  return interactiveComponents['host-preview'] || interactiveComponents['beacon:following-directory-no-live-hosts'] || interactiveComponents['directory-following-none'];
}
