/* globals i18n */
let libs = {};

let presenceHost = 'https://presence.twitch.tv';

function configurePubSub(driver) {
  libs.pubsub = driver;
}

function getActivityString(activityObj, isTruncated) {
  if (!activityObj || activityObj.type === 'none') {
    return i18n('Online');
  }
  /* eslint-disable camelcase */
  let {
    type,
    channel_display_name,
    channel_login,
    game,
    hosted_channel_display_name,
    hosted_channel_login,
    game_display_context
  } = activityObj;

  game = game ? game.trim() : null;

  let hostedChannel = hosted_channel_display_name || hosted_channel_login;
  let channel = channel_display_name || channel_login;
  let translation;

  if (type === 'watching') {
    if (hostedChannel) {
      if (isTruncated) {
        translation = i18n('watching ${channel}');
        return translation.replace('${channel}', hostedChannel);
      }
      translation = i18n('watching ${channel} with the ${hostedBy} community');
      return translation.replace('${channel}', hostedChannel).replace('${hostedBy}', channel);
    } else if (game) {
      if (isTruncated) {
        translation = i18n('watching ${channel}');
        return translation.replace('${channel}', channel);
      }
      translation = i18n('watching ${channel} stream ${game}');
      return translation.replace('${channel}', channel).replace('${game}', game);
    } else if (channel) {
      translation = i18n('watching ${channel}');
      return translation.replace('${channel}', channel);
    }
    return i18n('Online');
  } else if (type === 'playing') {
    if (game_display_context) {
      translation = i18n('playing ${game} - ${gameDisplayContext}');
      return translation.replace('${game}', game).replace('${gameDisplayContext}', game_display_context);
    }
    translation = i18n('playing ${game}');
    return translation.replace('${game}', game);
  } else if (game) {
    translation = i18n('streaming ${game}');
    return translation.replace('${game}', game);
  }
  return i18n('streaming');
  /* eslint-enable camelcase */
}

function getRichPresence(availability, activityObj, isTruncated) {
  isTruncated = isTruncated || null;
  if (availability === 'online') {
    return getActivityString(activityObj, isTruncated);
  } else if (availability === 'idle') {
    if (activityObj && activityObj.type !== 'none') {
      return getActivityString(activityObj, isTruncated);
    }
    return i18n('Idle');
  }
  return i18n('Offline');
}

export {
  libs,
  configurePubSub,
  getActivityString,
  getRichPresence,
  presenceHost
};
