const ROUTE_MATCHERS = {
  channelany: /channel\./,
  channel: /channel\.index/,
  videos: /channel\.videos/,
  clips: /channel\.clips/,
  community: /communities\.community/,
  collections: /channel\.collections/,
  vod: /vod/,
  following: /channel\.following/,
  followers: /channel\.followers/,
  friends: /friends/,
  dashboard: /user.dashboards\./,
  directory: /directory/,
  directoryGame: /^directory.game.index$/,
  directoryGames: /^directory.games$/,
  directoryCreative: /^directory.creative.index$/,
  directoryAllChannels: /^directory.channels.all$/,
  index: /^index$/,
  userVod: /^user.vod$/
};

export const ROUTES = {
  CHANNEL_ANY: 'channelany',
  CHANNEL_PAGE: 'channel',
  VIDEOS_PAGE: 'videos',
  CLIPS_PAGE: 'clips',
  COMMUNITY_PAGE: 'community',
  COLLECTIONS_PAGE: 'collections',
  VOD_PAGE: 'vod',
  FOLLOWING_PAGE: 'following',
  FOLLOWERS_PAGE: 'followers',
  FRIENDS_PAGE: 'friends',
  DASHBOARD_PAGE: 'dashboard',
  DIRECTORY: 'directory',
  DIRECTORY_ALL_CHANNELS: 'directoryAllChannels',
  DIRECTORY_CREATIVE: 'directoryCreative',
  DIRECTORY_GAME: 'directoryGame',
  DIRECTORY_GAMES: 'directoryGames',
  INDEX: 'index',
  USER_VOD: 'userVod'
};

/**
 * routeMatchIDs is either a single route ID, or an array of them
 * The route IDs that can be matched against are defined above (add more as needed)
 *
 * returns whether the provided ember route matches one of the routes
 * represented as route IDs
 */
export function routeMatches(currentRoute, routeMatchIDs) {
  if (!Array.isArray(routeMatchIDs)) {
    return currentRoute.match(ROUTE_MATCHERS[routeMatchIDs]) !== null;
  }

  let matches = false;

  routeMatchIDs.forEach(function(routeId) {
    if (currentRoute.match(ROUTE_MATCHERS[routeId]) !== null) {
      matches = true;
    }
  });

  return matches;
}
